<?php
namespace Elementor;

/**
 * @package     WordPress
 * @subpackage  Gum Elementor Addon
 * @author      support@themegum.com
 * @since       1.0.8
*/

defined('ABSPATH') or die();


class Gum_Elementor_Widget_Icon_Button{


  public function __construct( $data = [], $args = null ) {

      add_action( 'elementor/element/button/section_style/after_section_end', array( $this, 'register_section_icon_style_controls') , 999 );
 /*
      add_action( 'elementor/element/icon-list/section_text_style/after_section_end', array( $this, 'register_section_text_style_controls') , 999 );
      add_action( 'elementor/element/icon-box/section_style_content/after_section_end', array( $this, 'register_section_style_content_controls') , 999 );
      add_action( 'elementor/element/image-box/section_style_content/after_section_end', array( $this, 'register_section_style_content_controls') , 999 );
*/

      add_action( 'elementor/element/before_section_start', [ $this, 'enqueue_script' ] );

  }

  public function register_section_icon_style_controls( Controls_Stack $element ) {


    /**
    * - Add icon position left/right
    *
    */

    $element->start_injection( [
      'of' => 'hover_animation',
    ] );

    $element->add_control(
      'rotate',
      [
        'label' => esc_html__( 'Rotate', 'elementor' ),
        'type' => Controls_Manager::SLIDER,
        'size_units' => [ 'deg' ],
        'default' => [
          'size' => 0,
          'unit' => 'deg',
        ],
        'selectors' => [
          '{{WRAPPER}} .elementor-button:hover .elementor-button-icon i, {{WRAPPER}} .elementor-button:hover .elementor-button-icon svg' => 'transform: rotate({{SIZE}}{{UNIT}});',
        ],
        'condition' => [ 'selected_icon[value]!' => '' ],

      ]
    );

    $element->end_injection();

  }

  function register_section_text_style_controls( Controls_Stack $element ) {


    $element->update_control(
      'text_indent',
      [
        'label' => esc_html__( 'Text Indent', 'elementor' ),
        'type' => Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'max' => 50,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}}:NOT(.elementor-icon-list-ico-position-10) .elementor-icon-list-text' => is_rtl() ? 'padding-right: {{SIZE}}{{UNIT}};' : 'padding-left: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}}.elementor-icon-list-ico-position-10 .elementor-icon-list-text' => is_rtl() ? 'padding-left: {{SIZE}}{{UNIT}};' : 'padding-right: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $element->start_injection( [
      'of' => 'text_indent',
    ] );


    $element->add_responsive_control(
      'text_display',
      [
        'label' => esc_html__( 'Text Hidden', 'gum-elementor-addon' ),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__( 'Yes', 'gum-elementor-addon' ),
        'label_off' => esc_html__( 'No', 'gum-elementor-addon' ),
        'default' => '',
        'devices' => ['tablet','mobile'],
        'prefix_class' => 'elementor-icon-list-text-%s-hidden-',
      ]
    );

    $element->end_injection();


  }

  function register_section_style_content_controls( Controls_Stack $element ){


    $element->update_responsive_control(
      'title_bottom_space',
      [
        'label' => esc_html__( 'Spacing', 'elementor' ),
        'type' => Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .elementor-icon-box-title' => 'margin-bottom: {{SIZE}}{{UNIT}};margin-top: 0;',
          '{{WRAPPER}} .elementor-image-box-title' => 'margin-bottom: {{SIZE}}{{UNIT}};margin-top: 0;',
        ],
      ]
    );


  }

  public function enqueue_script( ) {

    wp_enqueue_style( 'gum-elementor-addon',GUM_ELEMENTOR_URL."css/style.css",array());

  }

}

new \Elementor\Gum_Elementor_Widget_Icon_Button();
?>
